<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Amazingoffercarouselkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'amazingoffercarouselkaveh';
  }

  public function get_title()
  {
    return esc_html__('کاروسل پیشنهاد شگفت انگیز', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentamazingoffercarouselkaveh',
      [
        'label' => esc_html__('عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'styleboxamazingoffercarouselkaveh',
      [
        'label' => esc_html__('طرح بندی المان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'one' => esc_html__('طرح بندی اول', 'kaveh-core'),
          'two' => esc_html__('طرح بندی دوم', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'tagheadingamazingoffercarouselkaveh',
      [
        'label' => esc_html__('تگ عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'titleamazingoffercarouselkaveh',
      [
        'label' => esc_html__('عنوان اصلی(بولد)', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('پیشنهاد', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title2amazingoffercarouselkaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('شگفت انگیز', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheading2amazingoffercarouselkaveh',
      [
        'label' => esc_html__('تگ زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'subtitleamazingoffercarouselkaveh',
      [
        'label' => esc_html__('زیرعنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__(' محصولات تخفیف دار', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'moreamazingoffercarouselkaveh',
      [
        'label' => esc_html__('نمایش دکمه بیشتر؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'buttonamazingoffercarouselkaveh',
      [
        'label' => esc_html__('دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مشاهده همه', 'kaveh-core'),
        'condition' => [
          'moreamazingoffercarouselkaveh' => 'yes',
        ],

      ]
    );
    $this->add_control(
      'buttonlinkamazingoffercarouselkaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'moreamazingoffercarouselkaveh' => 'yes',
        ],

      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'content2amazingoffercarouselkaveh',
      [
        'label' => esc_html__('محصولات', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'imgbackamazingoffercarouselkaveh',
      [
        'label' => esc_html__('تصویر پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-four::before' =>
            'background-image: url({{URL}})',
        ],
        'condition' => [
          'styleboxamazingoffercarouselkaveh' => 'two',
        ],
      ]
    );
    $options = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $options[$category->term_id] = $category->name;
    }
    $this->add_control(
      'catamazingoffercarouselkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $options,
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content3amazingoffercarouselkaveh',
      [
        'label' => esc_html__('تنظیمات کاروسل', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'productnumberamazingoffercarouselkaveh',
      [
        'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 20,
        'step' => 1,
        'default' => 5,
      ]
    );
    $this->add_control(
      'productcolumnamazingoffercarouselkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در دسکتاپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 5,

      ]
    );
    $this->add_control(
      'productcolumn2amazingoffercarouselkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در تبلت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 3,

      ]
    );
    $this->add_control(
      'productcolumn3amazingoffercarouselkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در موبایل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 2,

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_amazingoffercarouselkaveh',
      [
        'label' => esc_html__('استایل عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'textcoloramazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ عنوان اصلی بولد', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-title b' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'textcolor2amazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_amazingoffercarouselkaveh',
        'label' => esc_html__('تایپوگرافی عنوان اصلی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-title',
      ]
    );
    $this->add_control(
      'textcolor3amazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2_amazingoffercarouselkaveh',
        'label' => esc_html__('تایپوگرافی زیر عنوان', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-sub-title',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2_amazingoffercarouselkaveh',
      [
        'label' => esc_html__('استایل دکمه', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'moreamazingoffercarouselkaveh' => 'yes',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button_amazingoffercarouselkaveh',
        'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Text_Shadow::get_type(),
      [
        'name' => 'text_shadowamazingoffercarouselkaveh',
        'label' => esc_html__('سایه متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link',
      ]
    );
    $this->start_controls_tabs(
      'style_tabsamazingoffercarouselkaveh'
    );

    $this->start_controls_tab(
      'style_normal_tabamazingoffercarouselkaveh',
      [
        'label' => esc_html__('عادی', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbuttoncoloramazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncoloramazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiusamazingoffercarouselkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderamazingoffercarouselkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link',
      ]
    );
    $this->add_control(
      'buttonbordersamazingoffercarouselkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'borderamazingoffercarouselkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hove_tabamazingoffercarouselkaveh',
      [
        'label' => esc_html__('هاور', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbuttoncolorhoveramazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-link:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncolorhoveramazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .section-heading-link:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiushoveramazingoffercarouselkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderhoveramazingoffercarouselkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link:hover',
      ]
    );
    $this->add_control(
      'buttonbordershoveramazingoffercarouselkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'borderhoveramazingoffercarouselkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadowamazingoffercarouselkavehh',
        'label' => esc_html__('سایه دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .section-heading-link',
      ]
    );
    $this->add_control(
      'hr1amazingoffercarouselkaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'buttonpaddingamazingoffercarouselkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .section-heading-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style3_amazingoffercarouselkaveh',
      [
        'label' => esc_html__('استایل باکس', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'boxradiusamazingoffercarouselkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'styleboxamazingoffercarouselkaveh' => 'one',
        ],
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'boxradiusst2amazingoffercarouselkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'styleboxamazingoffercarouselkaveh' => 'two',
        ],
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-four-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'boxcolor1amazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه باکس دو', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffercarouselkaveh' => 'one',
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-wrapper::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'boxradius1amazingoffercarouselkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس دو', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'styleboxamazingoffercarouselkaveh' => 'one',
        ],
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-wrapper::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'boxcolor2amazingoffercarouselkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه باکس سه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'styleboxamazingoffercarouselkaveh' => 'one',
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-wrapper::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'boxradius2amazingoffercarouselkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس سه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'styleboxamazingoffercarouselkaveh' => 'one',
        ],
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-wrapper::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style4_amazingoffercarouselkaveh',
      [
        'label' => esc_html__('استایل تصویر پس زمینه', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'widthbgamazingoffercarouselkaveh',
      [
        'label' => esc_html__('عرض تصویر پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => '%',
          'size' => 100,
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-four::before' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'heightbgamazingoffercarouselkaveh',
      [
        'label' => esc_html__('ارتفاع تصویر پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 5,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => '%',
          'size' => 100,
        ],
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-four::before' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()): ?>
      <?php if ('one' === $settings['styleboxamazingoffercarouselkaveh']) { ?>
            <section class="amazing-offer position-relative">
              <div class="container">
                <!-- Start Heading -->
                <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
                  <div class="detail position-relative">
                    <<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>
                      class="section-heading-title"><b><?php echo esc_html($settings['titleamazingoffercarouselkaveh']); ?></b>
                      <?php echo esc_html($settings['title2amazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>>
                    <<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>
                      class="section-heading-sub-title"><?php echo esc_html($settings['subtitleamazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>>
                  </div>
                  <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                    <a href="<?php echo esc_url($settings['buttonlinkamazingoffercarouselkaveh']); ?>"
                      class="section-heading-link btn btn-outline-dark">
                      <?php echo esc_html($settings['buttonamazingoffercarouselkaveh']); ?></a>
                  <?php } ?>
                </div>
                <!-- End Heading -->
                <!-- Start Products -->
                <div class="amazing-offer-wrapper position-relative">
                  <div class="swiper swiper-amazing-offer overflow-hidden"
                    data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"300":{"slidesPerView":<?php echo esc_html($settings['productcolumn3amazingoffercarouselkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2amazingoffercarouselkaveh']); ?>,"spaceBetween":8},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnamazingoffercarouselkaveh']); ?>,"spaceBetween":11}}}'>
                    <div class="swiper-wrapper">
                      <?php

                      // WP_Query args
                      $q_pce_query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $settings['productnumberamazingoffercarouselkaveh'],
                        'order' => 'DESC',
                        'orderby' => 'date',
                        'meta_query' => array(
                          array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => '!=',
                          ),
                        ),
                        'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                      );

                      // Check if the category variable is empty
                      if (!empty($settings['catamazingoffercarouselkaveh'])) {
                        $q_pce_query_args['tax_query'] = array(
                          array(
                            'taxonomy' => 'product_cat',
                            'field' => 'tag_ID',
                            'terms' => $settings['catamazingoffercarouselkaveh'],
                          ),
                        );
                      }

                      // The Query
                      $pce_query = new \WP_Query($q_pce_query_args);


                      // The Loop
                      if ($pce_query->have_posts()) {
                        while ($pce_query->have_posts()) {
                          $pce_query->the_post(); ?>
                          <div class="swiper-slide">
                            <div class="product product1">
                              <div class="product-image">
                                <?php
                                global $product;
                                $product = wc_get_product();
                                $product_id = $product->get_id();
                                $product_type = $product->get_type();
                                $sale_price_dates_from = $sale_price_dates_to = '';
                                $sale_price = $product->get_sale_price();
                                $normal_price = $product->get_regular_price();
                                $pr_id = get_the_ID();
                                $stocka = $product->get_stock_status();
                                if (!empty($normal_price)) {
                                  if ("instock" == $stocka) {
                                    if (!empty($sale_price)) { ?>
                                      <div class="discount">
                                        % <?php
                                        $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                                        echo $percentage;
                                        ?>
                                      </div>
                                    <?php }
                                  }
                                } ?>

                                <div class="cs-height_10 cs-height_lg_10"></div>
                                <a href="<?php the_permalink(); ?>">
                                  <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
                                </a>
                              </div>
                              <div class="detail">
                                <h2>
                                  <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                                </h2>
                                <?php if ("instock" == $stocka) { ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <?php if (!empty($sale_price)) { ?>
                                      <div class="offer">
                                        <?php echo $normal_price; ?>
                                      </div>
                                      <div class="price mx-auto">
                                        <?php echo number_format($sale_price, 0, '.', ','); ?>
                                        <span> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                                      </div>
                                    <?php } else { ?>
                                      <div class="price mx-auto">
                                        <?php if (!empty($normal_price)) {
                                          echo number_format($normal_price, 0, '.', ',');
                                        } ?>
                                        <span> <?php echo get_woocommerce_currency_symbol(); ?></span>
                                      </div>
                                    <?php } ?>
                                  <?php } else {
                                    $price_v = $product->get_price_html();
                                    echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v);
                                  }
                                  ?>
                                <?php }
                                ?>
                                <div class="product-hover">
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده محصول </a>
                                  <?php } else { ?>
                                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده گزینه ها</a>
                                  <?php } ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <?php if ("instock" == $stocka) { ?>
                                      <button type="submit" name="add-to-cart" value="<?php echo $pr_id ?>"
                                        class="single_add_to_cart_button btn btn-secondary rounded-circle icarrt">
                                        <i class="icon icon-cart-3"></i>
                                      </button>
                                    <?php }
                                  } ?>
                                  <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
                                </div>
                              </div>
                            </div>
                          </div>
                        <?php }
                      } else {
                        // There are no posts
                      }

                      // Reset Original Post Data
                      wp_reset_postdata();



                      ?>
                    </div>
                  </div>
                  <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                    <div class="swiper-button-next d-none d-sm-block"></div>
                    <div class="swiper-button-prev d-none d-sm-block"></div>
                  <?php } ?>
                </div>
                <!-- End Products -->
                <button class="amazing-offer-btn" data-scroll-to="#banners"></button>
              </div>
            </section>
          <?php } elseif ('two' === $settings['styleboxamazingoffercarouselkaveh']) { ?>
            <section class="amazing-offer amazing-offer-four position-relative">
              <div class="container">
                <!-- Start Heading -->
                <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
                  <div class="detail position-relative">
                    <<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?> class="section-heading-title">
                      <b><?php echo esc_html($settings['titleamazingoffercarouselkaveh']); ?></b>
                      <?php echo esc_html($settings['title2amazingoffercarouselkaveh']); ?> </<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>>
                    <<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>
                      class="section-heading-sub-title">
                      <?php echo esc_html($settings['subtitleamazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>>
                  </div>
                  <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                    <a href="<?php echo esc_url($settings['buttonlinkamazingoffercarouselkaveh']); ?>"
                      class="section-heading-link btn btn-outline-dark">
                      <?php echo esc_html($settings['buttonamazingoffercarouselkaveh']); ?> </a>
                  <?php } ?>
                </div>
                <!-- End Heading -->
                <!-- Start Products -->
                <div class="amazing-offer-four-wrapper position-relative">
                  <div class="swiper swiper-amazing-offer overflow-hidden"
                    data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"300":{"slidesPerView":<?php echo esc_html($settings['productcolumn3amazingoffercarouselkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2amazingoffercarouselkaveh']); ?>,"spaceBetween":8},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnamazingoffercarouselkaveh']); ?>,"spaceBetween":11}}}'>
                    <div class="swiper-wrapper">
                      <?php

                      // WP_Query args
                      $q_pce_query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $settings['productnumberamazingoffercarouselkaveh'],
                        'order' => 'DESC',
                        'orderby' => 'date',
                        'tax_query' => array(
                          array(
                            "taxonomy" => "product_cat",
                            "field" => "tag_ID",
                            "terms" => $settings['catamazingoffercarouselkaveh'],
                          ),
                        ),
                        'meta_query' => array(
                          array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => '!=',
                          ),
                        ),
                        'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())

                      );

                      // The Query
                      $pce_query = new \WP_Query($q_pce_query_args);

                      // The Loop
                      if ($pce_query->have_posts()) {
                        while ($pce_query->have_posts()) {
                          $pce_query->the_post();
                          global $product;
                          $product = wc_get_product();
                          $product_id = $product->get_id();
                          $product_type = $product->get_type();
                          $sale_price_dates_from = $sale_price_dates_to = '';
                          $sale_price = $product->get_sale_price();
                          $normal_price = $product->get_regular_price();
                          $pr_id = get_the_ID();
                          $stocka = $product->get_stock_status();
                          ?>
                          <div class="swiper-slide">
                            <div class="product product1 product-four">
                              <div class="product-image">
                                <?php if (!empty($normal_price)) {
                                  if ("instock" == $stocka) {
                                    if (!empty($sale_price)) { ?>
                                      <div class="discount">
                                        % <?php
                                        $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                                        echo $percentage;
                                        ?>
                                      </div>
                                    <?php }
                                  }
                                } ?>
                                <a href="<?php the_permalink(); ?>">
                                  <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
                                </a>
                              </div>
                              <div class="detail">
                                <h2>
                                  <a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a>
                                </h2>
                                <?php if ("instock" == $stocka) { ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <?php if (!empty($sale_price)) { ?>
                                      <div class="offer">
                                        <?php echo $normal_price; ?>
                                      </div>
                                      <div class="price mx-auto">
                                        <?php echo number_format($sale_price, 0, '.', ','); ?>
                                        <span> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                                      </div>
                                    <?php } else { ?>
                                      <div class="price mx-auto">
                                        <?php if (!empty($normal_price)) {
                                          echo number_format($normal_price, 0, '.', ',');
                                        } ?>
                                        <span> <?php echo get_woocommerce_currency_symbol(); ?></span>
                                      </div>
                                    <?php } ?>
                                  <?php } else {
                                    $price_v = $product->get_price_html();
                                    echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v);
                                  }
                                  ?>
                                <?php }
                                ?>
                                <div class="product-hover">
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده محصول </a>
                                  <?php } else { ?>
                                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده گزینه ها</a>
                                  <?php } ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <?php if ("instock" == $stocka) { ?>
                                      <button type="submit" name="add-to-cart" value="<?php echo $pr_id ?>"
                                        class="single_add_to_cart_button btn btn-secondary rounded-circle icarrt">
                                        <i class="icon icon-cart-3"></i>
                                      </button>
                                    <?php }
                                  } ?>
                                  <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
                                </div>
                              </div>
                            </div>
                          </div>
                        <?php }
                      } else {
                        // There are no posts
                      }
                      // Reset Original Post Data
                      wp_reset_postdata();
                      ?>
                    </div>
                  </div>
                  <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                    <div class="swiper-button-next d-none d-sm-block"></div>
                    <div class="swiper-button-prev d-none d-sm-block"></div>
                  <?php } ?>
                </div>
                <!-- End Products -->
                <button class="amazing-offer-btn"></button>
              </div>
            </section>
          <?php } ?>
          <?php do_action('kelementor_inline_scripts'); ?>
    <?php else: ?>
      <div class="kel-widget">

        <?php if ('one' === $settings['styleboxamazingoffercarouselkaveh']) { ?>
          <section class="amazing-offer position-relative skeleton-display">
            <div class="container">
              <!-- Start Heading -->
              <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
                <div class="detail position-relative">
                  <<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>
                    class="section-heading-title"><b><?php echo esc_html($settings['titleamazingoffercarouselkaveh']); ?></b>
                    <?php echo esc_html($settings['title2amazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>>
                  <<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>
                    class="section-heading-sub-title"><?php echo esc_html($settings['subtitleamazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>>
                </div>
                <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                  <a href="<?php echo esc_url($settings['buttonlinkamazingoffercarouselkaveh']); ?>"
                    class="section-heading-link btn btn-outline-dark">
                    <?php echo esc_html($settings['buttonamazingoffercarouselkaveh']); ?></a>
                <?php } ?>
              </div>
              <!-- End Heading -->
              <!-- Start Products -->
              <div class="amazing-offer-wrapper position-relative">

                <?php if (wp_is_mobile()): ?>
                  <div class="skeleton-loader">
                    <div class="skeleton-header"></div>
                    <div class="skeleton-content"></div>
                    <div class="skeleton-p"></div>
                    <div class="skeleton-p"></div>
                    <div class="skeleton-footer"></div>
                  </div>
                <?php else: ?>
                  <div class="row">
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>
              </div>
              <!-- End Products -->
              <button class="amazing-offer-btn" data-scroll-to="#banners"></button>
            </div>
          </section>
        <?php } elseif ('two' === $settings['styleboxamazingoffercarouselkaveh']) { ?>
          <section class="amazing-offer amazing-offer-four position-relative skeleton-display">
            <div class="container">
              <!-- Start Heading -->
              <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
                <div class="detail position-relative">
                  <<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?> class="section-heading-title">
                    <b><?php echo esc_html($settings['titleamazingoffercarouselkaveh']); ?></b>
                    <?php echo esc_html($settings['title2amazingoffercarouselkaveh']); ?> </<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>>
                  <<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>
                    class="section-heading-sub-title">
                    <?php echo esc_html($settings['subtitleamazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>>
                </div>
                <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                  <a href="<?php echo esc_url($settings['buttonlinkamazingoffercarouselkaveh']); ?>"
                    class="section-heading-link btn btn-outline-dark">
                    <?php echo esc_html($settings['buttonamazingoffercarouselkaveh']); ?> </a>
                <?php } ?>
              </div>
              <!-- End Heading -->
              <!-- Start Products -->
              <div class="amazing-offer-four-wrapper position-relative">
                <?php if (wp_is_mobile()): ?>
                  <div class="skeleton-loader">
                    <div class="skeleton-header"></div>
                    <div class="skeleton-content"></div>
                    <div class="skeleton-p"></div>
                    <div class="skeleton-p"></div>
                    <div class="skeleton-footer"></div>
                  </div>
                <?php else: ?>
                  <div class="row">
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>
              </div>
              <!-- End Products -->
              <button class="amazing-offer-btn"></button>
            </div>
          </section>
        <?php } ?>

        <div class="kel-content" style="display:none">
          <?php if ('one' === $settings['styleboxamazingoffercarouselkaveh']) { ?>
            <section class="amazing-offer position-relative">
              <div class="container">
                <!-- Start Heading -->
                <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
                  <div class="detail position-relative">
                    <<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>
                      class="section-heading-title"><b><?php echo esc_html($settings['titleamazingoffercarouselkaveh']); ?></b>
                      <?php echo esc_html($settings['title2amazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>>
                    <<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>
                      class="section-heading-sub-title"><?php echo esc_html($settings['subtitleamazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>>
                  </div>
                  <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                    <a href="<?php echo esc_url($settings['buttonlinkamazingoffercarouselkaveh']); ?>"
                      class="section-heading-link btn btn-outline-dark">
                      <?php echo esc_html($settings['buttonamazingoffercarouselkaveh']); ?></a>
                  <?php } ?>
                </div>
                <!-- End Heading -->
                <!-- Start Products -->
                <div class="amazing-offer-wrapper position-relative">
                  <div class="swiper swiper-amazing-offer overflow-hidden"
                    data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"300":{"slidesPerView":<?php echo esc_html($settings['productcolumn3amazingoffercarouselkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2amazingoffercarouselkaveh']); ?>,"spaceBetween":8},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnamazingoffercarouselkaveh']); ?>,"spaceBetween":11}}}'>
                    <div class="swiper-wrapper">
                      <?php

                      // WP_Query args
                      $q_pce_query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $settings['productnumberamazingoffercarouselkaveh'],
                        'order' => 'DESC',
                        'orderby' => 'date',
                        'meta_query' => array(
                          array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => '!=',
                          ),
                        ),
                        'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                      );

                      // Check if the category variable is empty
                      if (!empty($settings['catamazingoffercarouselkaveh'])) {
                        $q_pce_query_args['tax_query'] = array(
                          array(
                            'taxonomy' => 'product_cat',
                            'field' => 'tag_ID',
                            'terms' => $settings['catamazingoffercarouselkaveh'],
                          ),
                        );
                      }

                      // The Query
                      $pce_query = new \WP_Query($q_pce_query_args);


                      // The Loop
                      if ($pce_query->have_posts()) {
                        while ($pce_query->have_posts()) {
                          $pce_query->the_post(); ?>
                          <div class="swiper-slide">
                            <div class="product product1">
                              <div class="product-image">
                                <?php
                                global $product;
                                $product = wc_get_product();
                                $product_id = $product->get_id();
                                $product_type = $product->get_type();
                                $sale_price_dates_from = $sale_price_dates_to = '';
                                $sale_price = $product->get_sale_price();
                                $normal_price = $product->get_regular_price();
                                $pr_id = get_the_ID();
                                $stocka = $product->get_stock_status();
                                if (!empty($normal_price)) {
                                  if ("instock" == $stocka) {
                                    if (!empty($sale_price)) { ?>
                                      <div class="discount">
                                        % <?php
                                        $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                                        echo $percentage;
                                        ?>
                                      </div>
                                    <?php }
                                  }
                                } ?>

                                <div class="cs-height_10 cs-height_lg_10"></div>
                                <a href="<?php the_permalink(); ?>">
                                  <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
                                </a>
                              </div>
                              <div class="detail">
                                <h2>
                                  <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                                </h2>
                                <?php if ("instock" == $stocka) { ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <?php if (!empty($sale_price)) { ?>
                                      <div class="offer">
                                        <?php echo $normal_price; ?>
                                      </div>
                                      <div class="price mx-auto">
                                        <?php echo number_format($sale_price, 0, '.', ','); ?>
                                        <span> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                                      </div>
                                    <?php } else { ?>
                                      <div class="price mx-auto">
                                        <?php if (!empty($normal_price)) {
                                          echo number_format($normal_price, 0, '.', ',');
                                        } ?>
                                        <span> <?php echo get_woocommerce_currency_symbol(); ?></span>
                                      </div>
                                    <?php } ?>
                                  <?php } else {
                                    $price_v = $product->get_price_html();
                                    echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v);
                                  }
                                  ?>
                                <?php }
                                ?>
                                <div class="product-hover">
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده محصول </a>
                                  <?php } else { ?>
                                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده گزینه ها</a>
                                  <?php } ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <?php if ("instock" == $stocka) { ?>
                                      <button type="submit" name="add-to-cart" value="<?php echo $pr_id ?>"
                                        class="single_add_to_cart_button btn btn-secondary rounded-circle icarrt">
                                        <i class="icon icon-cart-3"></i>
                                      </button>
                                    <?php }
                                  } ?>
                                  <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
                                </div>
                              </div>
                            </div>
                          </div>
                        <?php }
                      } else {
                        // There are no posts
                      }

                      // Reset Original Post Data
                      wp_reset_postdata();



                      ?>
                    </div>
                  </div>
                  <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                    <div class="swiper-button-next d-none d-sm-block"></div>
                    <div class="swiper-button-prev d-none d-sm-block"></div>
                  <?php } ?>
                </div>
                <!-- End Products -->
                <button class="amazing-offer-btn" data-scroll-to="#banners"></button>
              </div>
            </section>
          <?php } elseif ('two' === $settings['styleboxamazingoffercarouselkaveh']) { ?>
            <section class="amazing-offer amazing-offer-four position-relative">
              <div class="container">
                <!-- Start Heading -->
                <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
                  <div class="detail position-relative">
                    <<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?> class="section-heading-title">
                      <b><?php echo esc_html($settings['titleamazingoffercarouselkaveh']); ?></b>
                      <?php echo esc_html($settings['title2amazingoffercarouselkaveh']); ?> </<?php echo esc_attr($settings['tagheadingamazingoffercarouselkaveh']); ?>>
                    <<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>
                      class="section-heading-sub-title">
                      <?php echo esc_html($settings['subtitleamazingoffercarouselkaveh']); ?></<?php echo esc_attr($settings['tagheading2amazingoffercarouselkaveh']); ?>>
                  </div>
                  <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                    <a href="<?php echo esc_url($settings['buttonlinkamazingoffercarouselkaveh']); ?>"
                      class="section-heading-link btn btn-outline-dark">
                      <?php echo esc_html($settings['buttonamazingoffercarouselkaveh']); ?> </a>
                  <?php } ?>
                </div>
                <!-- End Heading -->
                <!-- Start Products -->
                <div class="amazing-offer-four-wrapper position-relative">
                  <div class="swiper swiper-amazing-offer overflow-hidden"
                    data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"300":{"slidesPerView":<?php echo esc_html($settings['productcolumn3amazingoffercarouselkaveh']); ?>,"spaceBetween":8},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2amazingoffercarouselkaveh']); ?>,"spaceBetween":8},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnamazingoffercarouselkaveh']); ?>,"spaceBetween":11}}}'>
                    <div class="swiper-wrapper">
                      <?php

                      // WP_Query args
                      $q_pce_query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $settings['productnumberamazingoffercarouselkaveh'],
                        'order' => 'DESC',
                        'orderby' => 'date',
                        'tax_query' => array(
                          array(
                            "taxonomy" => "product_cat",
                            "field" => "tag_ID",
                            "terms" => $settings['catamazingoffercarouselkaveh'],
                          ),
                        ),
                        'meta_query' => array(
                          array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => '!=',
                          ),
                        ),
                        'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())

                      );

                      // The Query
                      $pce_query = new \WP_Query($q_pce_query_args);

                      // The Loop
                      if ($pce_query->have_posts()) {
                        while ($pce_query->have_posts()) {
                          $pce_query->the_post();
                          global $product;
                          $product = wc_get_product();
                          $product_id = $product->get_id();
                          $product_type = $product->get_type();
                          $sale_price_dates_from = $sale_price_dates_to = '';
                          $sale_price = $product->get_sale_price();
                          $normal_price = $product->get_regular_price();
                          $pr_id = get_the_ID();
                          $stocka = $product->get_stock_status();
                          ?>
                          <div class="swiper-slide">
                            <div class="product product1 product-four">
                              <div class="product-image">
                                <?php if (!empty($normal_price)) {
                                  if ("instock" == $stocka) {
                                    if (!empty($sale_price)) { ?>
                                      <div class="discount">
                                        % <?php
                                        $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                                        echo $percentage;
                                        ?>
                                      </div>
                                    <?php }
                                  }
                                } ?>
                                <a href="<?php the_permalink(); ?>">
                                  <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
                                </a>
                              </div>
                              <div class="detail">
                                <h2>
                                  <a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a>
                                </h2>
                                <?php if ("instock" == $stocka) { ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <?php if (!empty($sale_price)) { ?>
                                      <div class="offer">
                                        <?php echo $normal_price; ?>
                                      </div>
                                      <div class="price mx-auto">
                                        <?php echo number_format($sale_price, 0, '.', ','); ?>
                                        <span> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                                      </div>
                                    <?php } else { ?>
                                      <div class="price mx-auto">
                                        <?php if (!empty($normal_price)) {
                                          echo number_format($normal_price, 0, '.', ',');
                                        } ?>
                                        <span> <?php echo get_woocommerce_currency_symbol(); ?></span>
                                      </div>
                                    <?php } ?>
                                  <?php } else {
                                    $price_v = $product->get_price_html();
                                    echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v);
                                  }
                                  ?>
                                <?php }
                                ?>
                                <div class="product-hover">
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده محصول </a>
                                  <?php } else { ?>
                                    <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده گزینه ها</a>
                                  <?php } ?>
                                  <?php if (!$product->is_type('variable')) { ?>
                                    <?php if ("instock" == $stocka) { ?>
                                      <button type="submit" name="add-to-cart" value="<?php echo $pr_id ?>"
                                        class="single_add_to_cart_button btn btn-secondary rounded-circle icarrt">
                                        <i class="icon icon-cart-3"></i>
                                      </button>
                                    <?php }
                                  } ?>
                                  <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
                                </div>
                              </div>
                            </div>
                          </div>
                        <?php }
                      } else {
                        // There are no posts
                      }
                      // Reset Original Post Data
                      wp_reset_postdata();
                      ?>
                    </div>
                  </div>
                  <?php if ("yes" === $settings['moreamazingoffercarouselkaveh']) { ?>
                    <div class="swiper-button-next d-none d-sm-block"></div>
                    <div class="swiper-button-prev d-none d-sm-block"></div>
                  <?php } ?>
                </div>
                <!-- End Products -->
                <button class="amazing-offer-btn"></button>
              </div>
            </section>
          <?php } ?>
          <?php do_action('kelementor_inline_scripts'); ?>
        </div>
      </div>
    <?php endif; ?>
  <?php
  }
}