<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Aboutussecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'aboutussecondstkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان درباره ما سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentaboutussecondstkaveh',
        [
          'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleboxaboutussecondstkaveh',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),
            'five'  => esc_html__( 'طرح بندی پنج', 'kaveh-core' ),
            'six'  => esc_html__( 'طرح بندی شش', 'kaveh-core' ),
            'seven'  => esc_html__( 'طرح بندی هفت', 'kaveh-core' ),



    
          ],
        ]
        ); 
        $this->end_controls_section();
        $this->start_controls_section(
          'content2aboutussecondstkaveh',
          [
            'label' => esc_html__( 'تنظیمات عنوان', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
          ]
        );
      $this->add_control(
          'title1aboutussecondstkaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'فروشگاه', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1aboutussecondstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'condition' => [
            'styleboxaboutussecondstkaveh' => 'seven',
          ],
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'title2aboutussecondstkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دیجی کالا', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading2aboutussecondstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'descaboutussecondstkaveh',
      [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::WYSIWYG,
          'default' => esc_html__( 'با بیش از سی سال سابقه خدمت به مشتریان در زمینه فروش ابزارآلات صنعتی و کارگاهی را دارا می باشد و با گردهم آوردن متخصصان این عرصه بالغ بر ده سال است که برند را به صورت تخصصی در زمینه ابزار آلات عرضه کرده است. همچنین برای ارائه هرچه تمام تر فعالیت خود از سال فروشگاه اینترنتی ابزار را راه اندازی نموده است.', 'kaveh-core' ),
  
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content3aboutussecondstkaveh',
    [
      'label' => esc_html__( 'شبکه های اجتماعی', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
              'condition' => [
                'styleboxaboutussecondstkaveh!' => 'five',
              ],
    ]
  ); 
  $repeater = new \Elementor\Repeater();
  $repeater->add_control(
    'socialaboutussecondstkaveh',
    [
      'label' => esc_html__( 'آیکون شبکه اجتماعی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-instagram',
      ],
    ]
  ); 
  $repeater->add_control(
    'sociallinkaboutussecondstkaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),
  
    ]
  );
  $this->add_control(
  'listaboutussecondstkaveh',
  [
    'label' => esc_html__( 'شبکه های اجتماعی', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::REPEATER,
    'condition' => [
      'styleboxaboutussecondstkaveh!' => 'five',
    ],
    'fields' => $repeater->get_controls(),
    'default' => [
      [
        'socialaboutussecondstkaveh' => esc_html__( 'icon-instagram', 'kaveh-core' ),
        'sociallinkaboutussecondstkaveh' => esc_html__( '#', 'kaveh-core' ),
      ],
  ]
  ]
  
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content4aboutussecondstkaveh',
    [
      'label' => esc_html__( 'تصاویر', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
$this->add_control(
  'imgaboutussecondstkaveh',
  [
    'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .about-us-description::before' =>
          'background-image: url({{URL}})',
  ],
  ]
);

$this->add_control(
  'imgaboutusbacksecondstkaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .about-us-home-three::after' =>
          'background-image: url({{URL}})',
          '{{WRAPPER}} .about-us-eleven .detail::before' =>
          'background-image: url({{URL}})',
  ],
    'condition' => [
      'styleboxaboutussecondstkaveh' => ['one','four'],

    ],
  ]
);
$this->end_controls_section();

$this->start_controls_section(
  'style_aboutussecondstkaveh',
  [
    'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
  ]
);
$this->add_control(
  'textcolor3aboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}}  .content .ab5h span' => 'color: {{VALUE}}',
      '{{WRAPPER}}   .detail .ab5h' => 'color: {{VALUE}}',
      '{{WRAPPER}}  .ab5h' => 'color: {{VALUE}}',

    ],
  ]
); 
$this->add_group_control(
  \Elementor\Group_Control_Typography::get_type(),
  [
    'name' => 'title2_aboutussecondstkaveh',
    'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
    'selector' => '{{WRAPPER}} .content .ab5h span,{{WRAPPER}} .detail .ab5h,{{WRAPPER}} .ab5h' ,


  ]
);
$this->add_control(
  'textcolor2aboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}}  .content .ab5h, .detail .ab5h b, .ab5h b' => 'color: {{VALUE}}',
    ],
  ]
);
$this->add_group_control(
  \Elementor\Group_Control_Typography::get_type(),
  [
    'name' => 'title_aboutussecondstkaveh',
    'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
    'selector' => '{{WRAPPER}} .content .ab5h,{{WRAPPER}} .detail .ab5h b,{{WRAPPER}} .ab5h b,{{WRAPPER}} .abh5b',
  ]
);
$this->add_control(
  'pcolor2aboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}}  .content .aboutp' => 'color: {{VALUE}}',
      '{{WRAPPER}}  .aboutp' => 'color: {{VALUE}}',
      '{{WRAPPER}}  .about-us-eleven .detail p' => 'color: {{VALUE}}',
      '{{WRAPPER}}  .about-us-home-nine p' => 'color: {{VALUE}}',
      '{{WRAPPER}}  .about-us-fiveteen-wrapper p' => 'color: {{VALUE}}',
    ],
  ]
);
$this->add_group_control(
  \Elementor\Group_Control_Typography::get_type(),
  [
    'name' => 'p_aboutussecondstkaveh',
    'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
    'selector' => '{{WRAPPER}} .content .aboutp,{{WRAPPER}}  .aboutp,{{WRAPPER}} .about-us-eleven .detail p,{{WRAPPER}} .about-us-home-nine p,{{WRAPPER}} .about-us-fiveteen-wrapper p',
  ]
);
$this->add_control(
  'shapebef7aboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ پس زمینه شیپ عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'condition' => [
      'styleboxaboutussecondstkaveh' => 'seven',
    ],
    'selectors' => [
      '{{WRAPPER}} .about-us-description-content .heading::before' => 'background-color: {{VALUE}}',
    ],
  ]
); 

$this->end_controls_section();
$this->start_controls_section(
  'style3_aboutussecondstkaveh',
  [
    'label' => esc_html__( 'استایل شبکه های اجتماعی', 'kaveh-core' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => [
      'styleboxaboutussecondstkaveh!' => 'five',
    ],
  ]
);
$this->add_control(
  'iconsizeaboutussecondstkaveh',
  [
    'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px', '%' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 300,
        'step' => 1,
      ],
      '%' => [
        'min' => 0,
        'max' => 100,
      ],
    ],
    'default' => [
      'unit' => 'px',
      'size' =>20,
    ],
    'selectors' => [
      '{{WRAPPER}} .socials li a' => 'font-size: {{SIZE}}{{UNIT}};',
    ],
  ]
);
$this->start_controls_tabs(
  'style5_tabsaboutussecondstkaveh'
);
$this->start_controls_tab(
  'style1_normal_tababoutussecondstkaveh',
  [
    'label' => esc_html__( 'عادی', 'kaveh-core' ),
  ]
);
$this->add_control(
  'textbutton1coloraboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}} .socials li a' => 'color: {{VALUE}}',
    ],
  ]
); 
$this->add_control(
  'button1coloraboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'condition' => [
      'styleboxaboutussecondstkaveh!' => ['one','two','three'],
    ],
    'selectors' => [
      '{{WRAPPER}} .socials li a' => 'background-color: {{VALUE}}',
    ],
  ]
);  
$this->end_controls_tab();
$this->start_controls_tab(
  'style_hover1_tababoutussecondstkaveh',
  [
    'label' => esc_html__( 'هاور', 'kaveh-core' ),
  ]
);
$this->add_control(
  'textbutton1colorhoveraboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}} .socials li a:hover' => 'color: {{VALUE}}',
    ],
  ]
); 
$this->add_control(
  'button1colorhoveraboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'condition' => [
      'styleboxaboutussecondstkaveh!' => ['one','two','three'],
    ],
    'selectors' => [
      '{{WRAPPER}} .socials li a:hover' => 'background-color: {{VALUE}}',
    ],
  ]
); 

$this->end_controls_tab();
$this->end_controls_tabs();
$this->add_control(
  'hrcolorhoveraboutussecondstkaveh',
  [
    'type' => \Elementor\Controls_Manager::DIVIDER,
    'condition' => [
      'styleboxaboutussecondstkaveh' => 'three',
    ],
  ]
);
$this->add_control(
  'backcoloriconaboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ پس زمینه آیکون ها', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'condition' => [
      'styleboxaboutussecondstkaveh' => 'three',
    ],
    'selectors' => [
      '{{WRAPPER}} .about-us-home-seven .content .socials' => 'background-color: {{VALUE}}',
    ],
  ]
); 
$this->end_controls_section();
$this->start_controls_section(
  'style6_aboutussecondstkaveh',
  [
    'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
  ]
);
$this->add_control(
  'bgsizeaboutussecondstkaveh',
  [
    'label' => esc_html__( 'سایز تصویر پس زمینه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SELECT,
    'condition' => [
      'styleboxaboutussecondstkaveh' => 'one',

    ],
    'default' => 'cover',
    'options' => [
      'cover'  => esc_html__( 'کاور', 'kaveh-core' ),
      'custom'  => esc_html__( 'سفارشی', 'kaveh-core' ),  
    ],
  ]
  );

  $this->add_control(
    'widthbg7aboutussecondstkaveh',
    [
      'label' => esc_html__( 'عرض تصویر پس زمینه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'one',
        'bgsizeaboutussecondstkaveh' => 'custom',
          ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-three::after' => 'width: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'heigthbg7aboutussecondstkaveh',
    [
      'label' => esc_html__( 'ارتفاع تصویر پس زمینه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
          'styleboxaboutussecondstkaveh' => 'one',
          'bgsizeaboutussecondstkaveh' => 'custom',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-three::after' => 'height: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'hrbgaboutussecondstkaveh',
    [
      'type' => \Elementor\Controls_Manager::DIVIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'one',
  
      ],
    ]
  );
  $this->add_control(
    'widthimg7aboutussecondstkaveh',
    [
      'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'one',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ], 
      ],
      'default' => [
        'unit' => 'px',
        'size' => 440,
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-three-wrapper .content img' => 'width: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'heigthimg7aboutussecondstkaveh',
    [
      'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'one',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-three-wrapper .content img' => 'height: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'widthimg8aboutussecondstkaveh',
    [
      'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'two',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ], 
      ],
      'default' => [
        'unit' => 'px',
        'size' => 440,
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-five img' => 'width: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'heigthimg8aboutussecondstkaveh',
    [
      'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'two',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-five img' => 'height: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'widthimg9aboutussecondstkaveh',
    [
      'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'three',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ], 
      ],
      'default' => [
        'unit' => 'px',
        'size' => 440,
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-seven img' => 'width: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'heigthimg9aboutussecondstkaveh',
    [
      'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'three',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-seven img' => 'height: {{SIZE}}{{UNIT}};',
      ],
    ]
  );

  $this->add_control(
    'widthimg10aboutussecondstkaveh',
    [
      'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'four',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ], 
      ],
      'default' => [
        'unit' => 'px',
        'size' => 440,
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-eleven img' => 'width: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'heigthimg10aboutussecondstkaveh',
    [
      'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'four',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-eleven img' => 'height: {{SIZE}}{{UNIT}};',
      ],
    ]
  );
  $this->add_control(
    'widthimg11aboutussecondstkaveh',
    [
      'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'five',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ], 
      ],
      'default' => [
        'unit' => 'px',
        'size' => 440,
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-nine .ab5 img' => 'width: {{SIZE}}{{UNIT}} !important;',
      ],
    ]
  );
  $this->add_control(
    'heigthimg11aboutussecondstkaveh',
    [
      'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'five',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-home-nine .ab5 img' => 'height: {{SIZE}}{{UNIT}} !important;',
      ],
    ]
  );
  $this->add_control(
    'widthimg12aboutussecondstkaveh',
    [
      'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'six',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ], 
      ],
      'default' => [
        'unit' => 'px',
        'size' => 440,
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-fiveteen .about-us-fiveteen-wrapper .ab6 img' => 'width: {{SIZE}}{{UNIT}} !important;',
      ],
    ]
  );
  $this->add_control(
    'heigthimg12aboutussecondstkaveh',
    [
      'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'six',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ],
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-fiveteen .about-us-fiveteen-wrapper .ab6 img' => 'height: {{SIZE}}{{UNIT}} !important;',
      ],
    ]
  );
  $this->add_control(
    'widthimg17aboutussecondstkaveh',
    [
      'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'condition' => [
        'styleboxaboutussecondstkaveh' => 'seven',
      ],
      'size_units' => [ 'px', '%' ],
      'range' => [
        'px' => [
          'min' => 0,
          'max' => 2000,
          'step' => 5,
        ],
        '%' => [
          'min' => 0,
          'max' => 100,
        ], 
      ],
      'default' => [
        'unit' => 'px',
        'size' => 440,
      ],
      'selectors' => [
        '{{WRAPPER}} .about-us-description::before' => 'width: {{SIZE}}{{UNIT}} !important;',
      ],
    ]
  );
$this->end_controls_section();
$this->start_controls_section(
  'style7_aboutussecondstkaveh',
  [
    'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => [
      'styleboxaboutussecondstkaveh!' => ['six','five','seven','four'],
    ],
  ]
);
$this->add_control(
  'gra1coloraboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ اول پس زمینه باکس', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'condition' => [
      'styleboxaboutussecondstkaveh' => ['one','two'],
    ],
  ]
); 
$this->add_control(
  'gra2coloraboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ دوم پس زمینه باکس', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'condition' => [
      'styleboxaboutussecondstkaveh' => ['one','two'],
    ],
  ]
); 
$this->add_control(
  'gcoloraboutussecondstkaveh',
  [
    'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}} .about-us-home-seven::before' => 'background-color: {{VALUE}}',
    ],
    'condition' => [
      'styleboxaboutussecondstkaveh' => 'three',
    ],
  ]
); 
$this->end_controls_section();
   
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if('one'===$settings['styleboxaboutussecondstkaveh']){ ?>
    <section class="about-us-home-three position-relative">
      <div class="container">
        <div class="about-us-home-three-wrapper position-relative">
          <!-- Start Socials -->
          <ul class="socials position-absolute d-flex d-lg-block align-items-center">
          <?php
              if ( $settings['listaboutussecondstkaveh'] ) {
              foreach (  $settings['listaboutussecondstkaveh'] as $item ) {
              ?>
            <li>
              <a href="<?php echo  esc_url($item['sociallinkaboutussecondstkaveh']); ?>">
                <i class="<?php echo  esc_attr($item['socialaboutussecondstkaveh']['value']); ?>"></i>
              </a>
            </li>
            <?php 
            }
              }
            ?>
          </ul>
          <!-- End Socials -->
          <div class="content position-relative">
            <img src="<?php echo esc_url($settings['imgaboutussecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutussecondstkaveh'] )); ?>" />
            <div class="d-flex flex-column flex-sm-row">
              <<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?> class="text-nowrap ab5h">
                <span class="d-block"> <?php echo  esc_html($settings['title1aboutussecondstkaveh']); ?> </span>
                <?php echo  esc_html($settings['title2aboutussecondstkaveh']); ?>
              </<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?>>
              <p class="aboutp"> <?php echo $settings['descaboutussecondstkaveh']; ?> </p>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php }elseif('two'===$settings['styleboxaboutussecondstkaveh']){ ?>
    <section class="about-us-home-five">
      <div class="container d-flex align-items-center flex-column-reverse flex-lg-row">
        <div class="content position-relative">
          <<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?> class="ab5h">
            <span class="d-block fw-normal"> <?php echo  esc_html($settings['title1aboutussecondstkaveh']); ?> </span>
            <?php echo  esc_html($settings['title2aboutussecondstkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?>>
          <p class="aboutp"><?php echo $settings['descaboutussecondstkaveh']; ?></p>
          <ul class="socials d-flex align-items-center">
          <?php
              if ( $settings['listaboutussecondstkaveh'] ) {
              foreach (  $settings['listaboutussecondstkaveh'] as $item ) {
              ?>
            <li>
              <a href="<?php echo  esc_url($item['sociallinkaboutussecondstkaveh']); ?>">
                <i class="<?php echo  esc_attr($item['socialaboutussecondstkaveh']['value']); ?>"></i>
              </a>
            </li>
            <?php 
            }
              }
            ?>
          </ul>
        </div>
        <img src="<?php echo esc_url($settings['imgaboutussecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutussecondstkaveh'] )); ?>" class="d-block mb-4 mb-lg-0" />
      </div>
    </section>
    <?php }elseif('three'===$settings['styleboxaboutussecondstkaveh']){ ?>
    <section class="about-us-home-seven position-relative">
      <div class="container position-relative d-flex flex-column flex-lg-row">
        <img src="<?php echo esc_url($settings['imgaboutussecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutussecondstkaveh'] )); ?>" />
        <div class="content position-relative">
          <<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?> class="position-relative ab5h">
            <span class="d-block"><?php echo  esc_html($settings['title1aboutussecondstkaveh']); ?></span>
            <?php echo  esc_html($settings['title2aboutussecondstkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?>>
          <p class="mb-0 aboutp"><?php echo $settings['descaboutussecondstkaveh']; ?></p>
          <ul class="socials position-absolute top-50 end-0 rounded-pill translate-middle-y">
          <?php
              if ( $settings['listaboutussecondstkaveh'] ) {
              foreach (  $settings['listaboutussecondstkaveh'] as $item ) {
              ?>
            <li>
              <a href="<?php echo  esc_url($item['sociallinkaboutussecondstkaveh']); ?>">
                <i class="<?php echo  esc_attr($item['socialaboutussecondstkaveh']['value']); ?>"></i>
              </a>
            </li>
            <?php 
            }
              }
            ?>
          </ul>
        </div>
      </div>
    </section>
    <?php }elseif('four'===$settings['styleboxaboutussecondstkaveh']){ ?>
    <section class="about-us-eleven">
      <div class="container d-flex flex-column flex-lg-row position-relative">
        <img src="<?php echo esc_url($settings['imgaboutussecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutussecondstkaveh'] )); ?>" />
        <div class="detail position-relative">
          <div class="d-flex align-items-sm-center flex-column flex-sm-row">
            <<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?> class="mb-0 ab5h">
             <?php echo  esc_html($settings['title1aboutussecondstkaveh']); ?>
              <b class="d-block"><?php echo  esc_html($settings['title2aboutussecondstkaveh']); ?></b>
            </<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?>>
            <ul class="socials d-flex align-items-center ms-sm-auto ms-lg-0 mt-5 mt-sm-0">
            <?php
              if ( $settings['listaboutussecondstkaveh'] ) {
              foreach (  $settings['listaboutussecondstkaveh'] as $item ) {
              ?>
            <li>
              <a href="<?php echo  esc_url($item['sociallinkaboutussecondstkaveh']); ?>">
                <i class="<?php echo  esc_attr($item['socialaboutussecondstkaveh']['value']); ?>"></i>
              </a>
            </li>
            <?php 
            }
              }
            ?>
            </ul>
          </div>
          <p class="aboutp"><?php echo $settings['descaboutussecondstkaveh']; ?></p>
        </div>
      </div>
    </section>
    <?php }elseif('five'===$settings['styleboxaboutussecondstkaveh']){ ?>
    <section class="about-us-home-nine">
      <div class="container position-relative">
        <div class="row align-items-center">
          <div class="col-lg-6 order-2 order-lg-1">
            <<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?> class="position-relative ab5h">
            <?php echo  esc_html($settings['title1aboutussecondstkaveh']); ?>
              <b class="d-block"><?php echo  esc_html($settings['title2aboutussecondstkaveh']); ?></b>              
            </<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?>>
            <p class="mb-0 aboutp"><?php echo $settings['descaboutussecondstkaveh']; ?></p>
          </div>
          <div class="col-lg-6 order-1 order-lg-2 ab5">
            <img src="<?php echo esc_url($settings['imgaboutussecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutussecondstkaveh'] )); ?>" class="d-block w-100" />
          </div>
        </div>
      </div>
    </section>
    <?php }elseif('six'===$settings['styleboxaboutussecondstkaveh']){ ?>
    <section class="about-us-fiveteen">
      <div class="container">
        <div class="about-us-fiveteen-wrapper position-relative">
          <div class="row align-items-center">
            <div class="col-lg-4 ab6">
              <img src="<?php echo esc_url($settings['imgaboutussecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutussecondstkaveh'] )); ?>" class="d-block" />
            </div>
            <div class="col-lg-8">
              <div
                class="d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row gap-4 gap-sm-0">
                <<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?> class="mb-0 ab5h">
                <?php echo  esc_html($settings['title1aboutussecondstkaveh']); ?>
                  <b class="d-block"> <?php echo  esc_html($settings['title2aboutussecondstkaveh']); ?></b>
                </<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?>>
                <ul class="socials d-flex align-items-center">
                <?php
                  if ( $settings['listaboutussecondstkaveh'] ) {
                  foreach (  $settings['listaboutussecondstkaveh'] as $item ) {
                  ?>
                <li>
                  <a href="<?php echo  esc_url($item['sociallinkaboutussecondstkaveh']); ?>" class="d-block text-center rounded-circle">
                    <i class="<?php echo  esc_attr($item['socialaboutussecondstkaveh']['value']); ?>"></i>
                  </a>
                </li>
                <?php 
                }
                  }
                 ?>
                </ul> 
              </div>
              <p class="mb-0 aboutp">
              <?php echo $settings['descaboutussecondstkaveh']; ?>
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php }elseif('seven'===$settings['styleboxaboutussecondstkaveh']){ ?>
    <section class="about-us-description position-relative">
      <div class="container position-relative">
        <div class="about-us-description-content">
          <div
            class="heading d-flex align-items-sm-center justify-content-sm-between position-relative flex-column flex-sm-row">
            <div class="right detail">
              <<?php echo  esc_attr($settings['tagheading1aboutussecondstkaveh']); ?> class="name mb-0 ab5h"> <?php echo  esc_html($settings['title1aboutussecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheading1aboutussecondstkaveh']); ?>>
              <<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?> class="sub-title mb-0 abh5b"> <?php echo  esc_html($settings['title2aboutussecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheading2aboutussecondstkaveh']); ?>>
            </div>
            <ul class="socials d-flex align-items-center mt-4 mt-sm-0">
            <?php
                  if ( $settings['listaboutussecondstkaveh'] ) {
                  foreach (  $settings['listaboutussecondstkaveh'] as $item ) {
                  ?>
                <li>
                  <a href="<?php echo  esc_url($item['sociallinkaboutussecondstkaveh']); ?>" class="d-block text-center rounded-circle">
                    <i class="<?php echo  esc_attr($item['socialaboutussecondstkaveh']['value']); ?>"></i>
                  </a>
                </li>
                <?php 
                }
                  }
                 ?>
            </ul>
          </div>
          <p class="aboutp">
          <?php echo $settings['descaboutussecondstkaveh']; ?>
          </p>
        </div>
      </div>
    </section>
    <?php } ?>
    <style>
<?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-home-three-wrapper .content::after {
    background-image: -webkit-linear-gradient(right, <?php echo  esc_html($settings['gra1coloraboutussecondstkaveh']); ?>, <?php echo  esc_html($settings['gra2coloraboutussecondstkaveh']); ?>);
    background-image: -moz-linear-gradient(right, <?php echo  esc_html($settings['gra1coloraboutussecondstkaveh']); ?>, <?php echo  esc_html($settings['gra2coloraboutussecondstkaveh']); ?>);
    background-image: -o-linear-gradient(right, <?php echo  esc_html($settings['gra1coloraboutussecondstkaveh']); ?>, <?php echo  esc_html($settings['gra2coloraboutussecondstkaveh']); ?>);
    background-image: linear-gradient(to left, <?php echo  esc_html($settings['gra1coloraboutussecondstkaveh']); ?>, <?php echo  esc_html($settings['gra2coloraboutussecondstkaveh']); ?>);
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-home-five .content {
    background-image: -webkit-linear-gradient(315deg, <?php echo  esc_html($settings['gra1coloraboutussecondstkaveh']); ?> 55%, <?php echo  esc_html($settings['gra2coloraboutussecondstkaveh']); ?>);
    background-image: -moz-linear-gradient(315deg, <?php echo  esc_html($settings['gra1coloraboutussecondstkaveh']); ?> 55%, <?php echo  esc_html($settings['gra2coloraboutussecondstkaveh']); ?>);
    background-image: -o-linear-gradient(315deg, <?php echo  esc_html($settings['gra1coloraboutussecondstkaveh']); ?> 55%, <?php echo  esc_html($settings['gra2coloraboutussecondstkaveh']); ?>);
    background-image: linear-gradient(135deg, <?php echo  esc_html($settings['gra1coloraboutussecondstkaveh']); ?> 55%, <?php echo  esc_html($settings['gra2coloraboutussecondstkaveh']); ?>);

}
.about-us-eleven .detail::before {
    background-size: cover !important;
}
    <?php if('cover'===$settings['bgsizeaboutussecondstkaveh']){ ?>
      <?php echo '.elementor-element-' . $clsid . ''; ?>  .about-us-home-three::after {
      width: 100%;
      -webkit-background-size: cover !important;
      -moz-background-size: cover !important;
      -o-background-size: cover !important;
      background-size: cover !important;
      }
    <?php }?>
.about-us-description::before {
    -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;
}
    </style>

    <?php
  }


}
