<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Aboutuskaveh extends Widget_Base{

  public function get_name(){
    return 'aboutuskaveh';
  }

  public function get_title(){
    return esc_html__( 'المان درباره ما', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentaboutuskaveh',
        [
          'label' => esc_html__( 'محتوای عنوان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  
      $this->add_control(
          'title1aboutuskaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'فروشگاه', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1aboutuskaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H6',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'title2aboutuskaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دیجی کالا', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading2aboutuskaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'descaboutuskaveh',
      [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::WYSIWYG,
          'default' => esc_html__( 'با بیش از سی سال سابقه خدمت به مشتریان در زمینه فروش ابزارآلات صنعتی و کارگاهی را دارا می باشد و با گردهم آوردن متخصصان این عرصه بالغ بر ده سال است که برند را به صورت تخصصی در زمینه ابزار آلات عرضه کرده است. همچنین برای ارائه هرچه تمام تر فعالیت خود از سال فروشگاه اینترنتی ابزار را راه اندازی نموده است.', 'kaveh-core' ),
  
      ]
  ); 
  $this->end_controls_section();
  $this->start_controls_section(
    'content2aboutuskaveh',
    [
      'label' => esc_html__( 'آیکون های شبکه های اجتماعی', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );

  $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'socialaboutuskaveh',
      [
        'label' => esc_html__( 'آیکون شبکه اجتماعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-instagram',
        ],
      ]
    ); 
    $repeater->add_control(
      'sociallinkaboutuskaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'listaboutuskaveh',
    [
      'label' => esc_html__( 'شبکه های اجتماعی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'socialaboutuskaveh' => esc_html__( 'icon-instagram', 'kaveh-core' ),
          'sociallinkaboutuskaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content3aboutuskaveh',
    [
      'label' => esc_html__( 'دکمه ها', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
      $this->add_control(
        'timeaboutuskaveh',
        [
          'label' => esc_html__( 'نمایش دکمه اول؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'button1aboutuskaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( ' ساعت کار سایت ۹ الی ۱۹', 'kaveh-core' ),
            'condition' => [
              'timeaboutuskaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'icon1aboutuskaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-time',
        ],
      ]
    ); 
    $this->add_control(
      'button1linkaboutuskaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'timeaboutuskaveh' => 'yes',
          ],
    
      ]
    );
  $this->add_control(
    'moreaboutuskaveh',
    [
      'label' => esc_html__( 'نمایش دکمه دوم؟', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'yes' => esc_html__( 'بله', 'kaveh-core' ),
      'no' => esc_html__( 'خیر', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
  $this->add_control(
    'button2aboutuskaveh',
    [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'بیشتر', 'kaveh-core' ),
        'condition' => [
          'moreaboutuskaveh' => 'yes',
        ],

    ]
);
$this->add_control(
  'icon2aboutuskaveh',
  [
    'label' => esc_html__( 'آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-arrow-left',
    ],
  ]
); 
$this->add_control(
  'button2linkaboutuskaveh',
  [
      'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( '#', 'kaveh-core' ),
      'condition' => [
        'moreaboutuskaveh' => 'yes',
      ],

  ]
);
$this->end_controls_section();
$this->start_controls_section(
  'content4aboutuskaveh',
  [
    'label' => esc_html__( 'تصویر', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'imgaboutuskaveh',
  [
    'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);
$this->add_control(
  'shapeaboutuskaveh',
  [
    'label' => esc_html__( 'نمایش شیپ بالای باکس؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'no',
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_aboutuskaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor3aboutuskaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-heading .sup-title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_aboutuskaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home-heading .sup-title',
        ]
      );
      $this->add_control(
        'textcolor2aboutuskaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-heading .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_aboutuskaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home-heading .title',
        ]
      );
      $this->add_control(
        'textcolor2paboutuskaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlep_aboutuskaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style6_aboutuskaveh',
        [
          'label' => esc_html__( 'استایل شبکه های اجتماعی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        '1colorsocialaboutuskaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-heading ul li a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
        $this->add_control(
        '2colorsocialaboutuskaveh',
        [
          'label' => esc_html__( 'رنگ هاور آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-heading ul li:last-child a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_aboutuskaveh',
        [
          'label' => esc_html__( 'استایل دکمه اول', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'timeaboutuskaveh' => 'yes',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button1_aboutuskaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .time-work',
        ]
      );
      $this->add_control(
        'iconsizebutton1aboutuskaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text1_shadowaboutuskaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .time-work',
        ]
      );
      $this->start_controls_tabs(
        'style1_tabsaboutuskaveh'
      );
      
      $this->start_controls_tab(
        'style1_normal_tababoutuskaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1coloraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'button1coloraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'button1radiusaboutuskaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1aboutuskaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .time-work',
        ]
      );
      $this->add_control(
        'button1bordersaboutuskaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border1aboutuskaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hover1_tababoutuskaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1colorhoveraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'button1colorhoveraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'button1radiushoveraboutuskaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hoveraboutuskaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .time-work:hover',
        ]
      );
      $this->add_control(
        'button1bordershoveraboutuskaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border1hoveraboutuskaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow1aboutuskavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .time-work',
        ]
      );
      $this->add_control(
        'hr11aboutuskaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'button1paddingaboutuskaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .time-work' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_aboutuskaveh',
        [
          'label' => esc_html__( 'استایل دکمه دوم', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreaboutuskaveh' => 'yes',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button2_aboutuskaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .btn',
        ]
      );
      $this->add_control(
        'iconsizebutton2aboutuskaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text2_shadowaboutuskaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .btn',
        ]
      );
      $this->start_controls_tabs(
        'style2_tabsaboutuskaveh'
      );
      
      $this->start_controls_tab(
        'style2_normal_tababoutuskaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton2coloraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconbutton2colorhoveraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'button2coloraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'button2radiusaboutuskaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2aboutuskaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .btn',
        ]
      );
      $this->add_control(
        'button2bordersaboutuskaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2aboutuskaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hover2_tababoutuskaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton2colorhoveraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconhoverbutton2colorhoveraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn i:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'button2colorhoveraboutuskaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'button2radiushoveraboutuskaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2hoveraboutuskaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .btn:hover',
        ]
      );
      $this->add_control(
        'button2bordershoveraboutuskaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2hoveraboutuskaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2aboutuskavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home .btn',
        ]
      );
      $this->add_control(
        'hr12aboutuskaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'button2paddingaboutuskaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_aboutuskaveh',
        [
          'label' => esc_html__( 'استایل تصویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'imagewidthaboutuskaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => '%',
            'size' => 100,
          ],
          'selectors' => [
            '{{WRAPPER}} .image-about-one img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imageheightaboutuskaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .image-about-one img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <div class="about-us-home <?php if("yes"===$settings['shapeaboutuskaveh']){?>about-us-home-two<?php }else{} ?>">
    <div class="container position-relative">
        <div class="row align-items-center about-one">
          <div class="image-about-one col-lg-6 px-lg-0">
            <img src="<?php echo esc_url($settings['imgaboutuskaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutuskaveh'] )); ?>" />
          </div>
          <div class="col-lg-6 px-lg-0">
            <div class="about-us-home-heading d-flex align-items-center justify-content-between">
              <div class="name">
                <<?php echo  esc_attr($settings['tagheading1aboutuskaveh']); ?> class="sup-title"> <?php echo  esc_html($settings['title1aboutuskaveh']); ?></<?php echo  esc_attr($settings['tagheading1aboutuskaveh']); ?>>
                <<?php echo  esc_attr($settings['tagheading2aboutuskaveh']); ?> class="title position-relative"> <?php echo  esc_html($settings['title2aboutuskaveh']); ?> </<?php echo  esc_attr($settings['tagheading2aboutuskaveh']); ?>>
              </div>
              <ul class="d-flex align-items-center">
              <?php
              if ( $settings['listaboutuskaveh'] ) {
              foreach (  $settings['listaboutuskaveh'] as $item ) {
              ?>
                <li>
                  <a href="<?php echo  esc_url($item['sociallinkaboutuskaveh']); ?>">
                    <i class="<?php echo  esc_html($item['socialaboutuskaveh']['value']); ?>"></i>
                  </a>
                </li>
                <?php 
            }
              }
            ?>
              </ul>
            </div>
            <p>
            <?php echo $settings['descaboutuskaveh']; ?></p>
            <div class="d-flex align-items-center">
            <?php if("yes"===$settings['timeaboutuskaveh']){?>
              <a href="<?php echo  esc_url($settings['button1linkaboutuskaveh']); ?>">
              <div class="time-work">
                <i class="<?php echo  esc_html($settings['icon1aboutuskaveh']['value']); ?>"></i>
                <?php echo  esc_html($settings['button1aboutuskaveh']); ?>
              </div>
              </a>
              <?php }else{}  
               if("yes"===$settings['moreaboutuskaveh']){?>
              <a href="<?php echo  esc_url($settings['button2linkaboutuskaveh']); ?>" class="btn btn-dark">
              <?php echo  esc_html($settings['button2aboutuskaveh']); ?>
                <i class="<?php echo  esc_html($settings['icon2aboutuskaveh']['value']); ?>"></i>
              </a>
              <?php }else{}  ?>
            </div>
            </div>
            </div>
      </div>
    <?php
  }


}
