<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Aboutusfourthststkaveh extends Widget_Base{

  public function get_name(){
    return 'aboutusfourthststkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان درباره ما سبک چهار', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentaboutusfourthststkaveh',
        [
          'label' => esc_html__( 'محتوای عنوان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  
      $this->add_control(
          'title1aboutusfourthststkaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'فروشگاه', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1aboutusfourthststkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H6',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'title2aboutusfourthststkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دیجی کالا', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading2aboutusfourthststkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'title3aboutusfourthststkaveh',
      [
          'label' => esc_html__( 'عنوان محو اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'About us ...', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'descaboutusfourthststkaveh',
    [
        'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::WYSIWYG,
        'default' => esc_html__( 'با بیش از سی سال سابقه خدمت به مشتریان در زمینه فروش ابزارآلات صنعتی و کارگاهی را دارا می باشد و با گردهم آوردن متخصصان این عرصه بالغ بر ده سال است که برند را به صورت تخصصی در زمینه ابزار آلات عرضه کرده است. همچنین برای ارائه هرچه تمام تر فعالیت خود از سال فروشگاه اینترنتی ابزار را راه اندازی نموده است.', 'kaveh-core' ),

    ]
); 
  $this->add_control(
    'title4aboutusfourthststkaveh',
    [
        'label' => esc_html__( 'عنوان محو دوم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'Why choose us?', 'kaveh-core' ),

    ]
);
  $this->end_controls_section();
$this->start_controls_section(
  'content4aboutusfourthststkaveh',
  [
    'label' => esc_html__( 'تصاویر', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'imgaboutusfourthststkaveh',
  [
    'label' => esc_html__( 'تصویر بالای عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .about-us-home-eleven-content::after' =>
          'background: url({{URL}}) 0 0 no-repeat',
          '{{WRAPPER}} .about-us-home-eleven-content .sup-title::before' =>
          'background: url({{URL}}) 0 0 no-repeat',
  ],
  ]
);
$this->add_control(
  'img2aboutusfourthststkaveh',
  [
    'label' => esc_html__( 'تصویر اصلی', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'default' => [
      'url' => \Elementor\Utils::get_placeholder_image_src(),
    ],
  ]
);
$this->add_control(
  'img3aboutusfourthststkaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .about-us-home-eleven-wrapper::before' =>
          'background: url({{URL}}) 0 0 no-repeat',
  ],
  ]
);

       $this->end_controls_section();
       $this->start_controls_section(
        'style_aboutusfourthststkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor3aboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content .sup-title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_aboutusfourthststkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home-eleven-content .sup-title',
        ]
      );
      $this->add_control(
        'textcolor2aboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_aboutusfourthststkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home-eleven-content .title',
        ]
      );
      $this->add_control(
        'textcolor3paboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان محو اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content .title::before' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title3_aboutusfourthststkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان محو اول', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home-eleven-content .title::before',
        ]
      );
      $this->add_control(
        'textcolor2paboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlep_aboutusfourthststkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home-eleven-content p',
        ]
      );
      $this->add_control(
        'textcolor4paboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان محو دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content .title-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title4_aboutusfourthststkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان محو دوم', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about-us-home-eleven-content .title-en',
        ]
      );

      $this->end_controls_section();


      $this->start_controls_section(
        'style4_aboutusfourthststkaveh',
        [
          'label' => esc_html__( 'استایل تصویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'imagewidthaboutusfourthststkaveh',
        [
          'label' => esc_html__( 'عرض تصویر بالای عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content::after' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .about-us-home-eleven-content .sup-title::before' => 'width: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'imageheightaboutusfourthststkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر بالای عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px'],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content::after' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .about-us-home-eleven-content .sup-title::before' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_aboutusfourthststkaveh',
        [
          'label' => esc_html__( 'استایل باکس اصلی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bgcolor1paboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-wrapper::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'box1radiusaboutusfourthststkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-wrapper::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style6_aboutusfourthststkaveh',
        [
          'label' => esc_html__( 'استایل باکس محتوا', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bg2color1paboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه بیرونی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content::before' => 'border: 3px solid {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'borderbg2color2paboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه بیرونی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'bg2color2paboutusfourthststkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'box2radiusaboutusfourthststkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .about-us-home-eleven-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'padding1boxaboutusfourthststkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home-eleven-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="about-us-home-eleven my-100">
    <div class="container">
      <div class="about-us-home-eleven-wrapper position-relative">
        <div class="row">
          <div class="col-lg-6">
            <div class="about-us-home-eleven-content position-relative">
              <div class="title-en position-absolute top-0 start-100 text-nowrap d-none d-lg-block"><?php echo  esc_html($settings['title4aboutusfourthststkaveh']); ?>
              </div>
              <<?php echo  esc_attr($settings['tagheading1aboutusfourthststkaveh']); ?> class="sup-title"><?php echo  esc_html($settings['title1aboutusfourthststkaveh']); ?></<?php echo  esc_attr($settings['tagheading1aboutusfourthststkaveh']); ?>>
              <<?php echo  esc_attr($settings['tagheading2aboutusfourthststkaveh']); ?> class="title position-relative" data-title="<?php echo  esc_attr($settings['title3aboutusfourthststkaveh']); ?>"><?php echo  esc_html($settings['title2aboutusfourthststkaveh']); ?></<?php echo  esc_attr($settings['tagheading2aboutusfourthststkaveh']); ?>>
              <p class="mb-0"> <?php echo $settings['descaboutusfourthststkaveh']; ?></p>
            </div>
          </div>
          <div class="col-lg-6 d-none d-lg-block">
            <div class="image position-relative ms-auto">
              <img src="<?php echo esc_url($settings['img2aboutusfourthststkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['img2aboutusfourthststkaveh'] )); ?>" width="420" height="461" class="w-100 h-100">
              <img src="<?php echo esc_url($settings['img2aboutusfourthststkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['img2aboutusfourthststkaveh'] )); ?>" width="420" height="461"
                class="position-absolute top-0 end-0 w-100 h-100">
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <style>
    .about-us-home-eleven-wrapper::before {
    -webkit-background-size: cover !important ;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
.about-us-home-eleven-content::after, .about-us-home-eleven-content .sup-title::before {
  -webkit-background-size: contain !important ;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;    }
  </style>
    <?php
    if(empty($settings['imgaboutusfourthststkaveh']['url'])){?>
    <style>
      .about-us-home-eleven-content::after, .about-us-home-eleven-content .sup-title::before {
        background: unset !important;
    }
    </style>
    <?php
    }

  }


}
