<?php
  function inject_custom_control( $element, $section_id, $args ) {

	if ( ('ht-hf-mega-menu' === $element->get_name() && 'menu_sidebar_style' === $section_id) || ('ht-hf-nav-menu' === $element->get_name() && 'menu_sidebar_style' === $section_id)) {

		$element->start_controls_section(
			'custom_stylemenukaveh',
			[
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'استایل های اختصاصی کاوه', 'textdomain' ),
			]
		);
        $element->add_control(
            'iconsize1stylemenukaveh',
            [
              'label' => esc_html__( 'سایز آیکون منو دارای زیرمنو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 8,
              ],
              'selectors' => [
                '{{WRAPPER}} .boostify-menu .menu-item-has-children > a:after' => 'font-size: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
          $element->add_control(
            'iconmgr1stylemenukaveh',
            [
              'label' => esc_html__( 'فاصله از راست آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 8,
              ],
              'selectors' => [
                '{{WRAPPER}} .boostify-menu .menu-item-has-children > a:after' => 'margin-right: {{SIZE}}{{UNIT}};',
              ],
            ]
          );
        $element->start_controls_tabs(
            'style_tabsstylemenukaveh'
          );
          $element->start_controls_tab(
            'style_normal_tabstylemenukaveh',
            [
              'label' => esc_html__( 'عادی', 'kaveh-core' ),
            ]
          );
          $element->add_control(
            'buttoncolorstylemenukaveh',
            [
              'label' => esc_html__( 'رنگ پس زمینه منو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .boostify-menu > li > a' => 'background-color: {{VALUE}}',
              ],
            ]
          ); 
          $element->add_control(
            'buttoniconcolorstylemenukaveh',
            [
              'label' => esc_html__( 'رنگ آیکون منو دارای زیرمنو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .boostify-menu .menu-item-has-children > a:after' => 'color: {{VALUE}}',
              ],
            ]
          ); 
          $element->add_control(
            'buttonradiusstylemenukaveh',
            [
              'label' => esc_html__( 'گوشه خمیده منو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .boostify-menu > li > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );
          $element->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
              'name' => 'borderstylemenukaveh',
              'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} .boostify-menu > li > a',
            ]
          );
          $element->add_control(
            'buttonbordersstylemenukaveh',
            [
              'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'condition' => [
                'borderstylemenukaveh!' => '',
              ],
              'selectors' => [
                '{{WRAPPER}} .boostify-menu > li > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );
          $element->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
              'name' => 'box_shadowstylemenukaveh',
              'label' => esc_html__( 'سایه منو', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} .boostify-menu > li > a',
            ]
          );
          $element->end_controls_tab();
          $element->start_controls_tab(
            'style_hove_tabstylemenukaveh',
            [
              'label' => esc_html__( 'هاور', 'kaveh-core' ),
            ]
          );
          $element->add_control(
            'buttoncolorhoverstylemenukaveh',
            [
              'label' => esc_html__( 'رنگ پس زمینه منو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .boostify-menu > li:hover > a' => 'background-color: {{VALUE}}',
              ],
            ]
          ); 
          $element->add_control(
            'buttoniconhover1colorstylemenukaveh',
            [
              'label' => esc_html__( 'رنگ آیکون منو دارای زیرمنو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .boostify-menu .menu-item-has-children:hover > a:after' => 'color: {{VALUE}}',
              ],
            ]
          ); 
          $element->add_control(
            'buttonradiushoverstylemenukaveh',
            [
              'label' => esc_html__( 'گوشه خمیده منو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .boostify-menu > li:hover > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );
          $element->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
              'name' => 'borderhoverstylemenukaveh',
              'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} .boostify-menu > li:hover > a',
            ]
          );
          $element->add_control(
            'buttonbordershoverstylemenukaveh',
            [
              'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'condition' => [
                'borderhoverstylemenukaveh!' => '',
              ],
              'selectors' => [
                '{{WRAPPER}} .boostify-menu > li:hover > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );
          $element->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
              'name' => 'box_shadowhoverstylemenukaveh',
              'label' => esc_html__( 'سایه منو', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} .boostify-menu > li:hover > a',
            ]
          );
          $element->end_controls_tab();
          $element->end_controls_tabs();
          $element->add_control(
            'hr11megamenutwokaveh',
            [
              'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
          );
          $element->add_control(
            'buttonmarginstylemenukaveh',
            [
              'label' => esc_html__( 'مارجین منو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .boostify-menu > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );
          $element->add_control(
            'hr12megamenutwokaveh',
            [
              'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
          );
          $element->add_control(
            'buttoniconmarginstylemenukaveh',
            [
              'label' => esc_html__( 'مارجین آیکون منو', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .boostify-menu > li .menu-item-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );
		$element->end_controls_section();

	}

}
add_action( 'elementor/element/after_section_end', 'inject_custom_control', 10, 3 );




